#include "stdafx.h"
#include "win_demo.h"
#include "DialogRecordDirectory.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"

extern int m_handle;
extern int m_chn_option;

IMPLEMENT_DYNAMIC(CDialogRecordDirectory, CDialogEx)

CDialogRecordDirectory::CDialogRecordDirectory(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_RECORD_DIRECTORY, pParent)
{

}

CDialogRecordDirectory::~CDialogRecordDirectory()
{
}

void CDialogRecordDirectory::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_DISK_ID, m_disk_id);
	DDX_Control(pDX, IDC_COMBO_DISK_TYPE, m_disk_type);
	DDX_Control(pDX, IDC_COMBO_DISK_STATE, m_disk_state);
	DDX_Control(pDX, IDC_EDIT_TOTAL_SPACE, m_total_space);
	DDX_Control(pDX, IDC_EDIT_USABLE_SPACE, m_usable_space);
}

jy_dev_record_directory_list_t strecord_directory = { 0 };
BOOL CDialogRecordDirectory::OnInitRecordDirectory()
{
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	nRet = sdks_get_disk_report(m_handle, m_chn_option, &p_result);
	if (0 == nRet)
	{
		memset(&strecord_directory, 0, sizeof(jy_dev_record_directory_list_t));
		json_perser_record_directory(p_result, &strecord_directory);
		m_disk_id.ResetContent();
		for (int i = 0; i < strecord_directory.num; ++i)
		{
			strins.Format(_T("%d"), strecord_directory.record_directory_list[i].disk_id);
			m_disk_id.InsertString(i, strins);
		}
		m_disk_id.SetCurSel(0);
		m_disk_type.ResetContent();
		m_disk_type.InsertString(0, TEXT("Local disk"));
		m_disk_type.InsertString(1, TEXT("SD Card"));
		m_disk_type.InsertString(2, TEXT("FTP"));
		m_disk_type.InsertString(3, TEXT("NAS"));
		m_disk_type.InsertString(4, TEXT("External device"));
		m_disk_type.InsertString(5, TEXT("Remote device"));
		m_disk_type.InsertString(6, TEXT("ESata"));
		m_disk_type.InsertString(7, TEXT("Raid"));
		m_disk_state.ResetContent();
		m_disk_state.InsertString(0, TEXT("No available"));
		m_disk_state.InsertString(1, TEXT("Available"));
		OnCbnSelchangeComboDiskId();
	}
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogRecordDirectory, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_DISK_ID, &CDialogRecordDirectory::OnCbnSelchangeComboDiskId)
	ON_BN_CLICKED(IDOK, &CDialogRecordDirectory::OnBnClickedOk)
END_MESSAGE_MAP()


void CDialogRecordDirectory::OnCbnSelchangeComboDiskId()
{
	CString strins;
	int disk_id = m_disk_id.GetCurSel();
	m_disk_type.SetCurSel(strecord_directory.record_directory_list[disk_id].disk_type - 1);
	m_disk_state.SetCurSel(strecord_directory.record_directory_list[disk_id].disk_state);
	strins.Format(_T("%d"), strecord_directory.record_directory_list[disk_id].disk_space);
	m_total_space.SetWindowTextA(strins);
	strins.Format(_T("%d"), strecord_directory.record_directory_list[disk_id].disk_free_space);
	m_usable_space.SetWindowTextA(strins);
}


void CDialogRecordDirectory::OnBnClickedOk()
{
	CDialogEx::OnOK();
	int disk_id = m_disk_id.GetCurSel() + 1;
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to format the disk?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		int nRet = sdks_disk_format(m_handle, m_chn_option, disk_id);
		if (nRet) {
			MessageBoxA("Format disk fail!");
		}
	}
}
